<?php
/* --------------------------------------------------------------
 ServiceProvider.php 2020-04-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\ServiceProviders\Abstraction;

use Gambio\Core\Application\Application;
use League\Container\ServiceProvider\ServiceProviderInterface;

/**
 * Interface ServiceProvider
 * @package Gambio\Core\Application\ServiceProviders\Abstraction
 */
interface ServiceProvider
{
    /**
     * ServiceProvider constructor.
     *
     * @param Application $application
     */
    public function __construct(Application $application);
    
    
    /**
     * Returns a list of services that should be available by the container.
     *
     * @return array
     */
    public function provides(): array;
    
    
    /**
     * Registers services and their dependencies.
     */
    public function register(): void;
    
    
    /**
     * Converts the gambio service provider implementation into a league/container compatible implementation.
     *
     * @return ServiceProviderInterface
     */
    public function toLeagueInterface(): ServiceProviderInterface;
}